Rem
Rem remove.sql
Rem
Rem Copyright (c) 2005, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      remove.sql 
Rem
Rem    DESCRIPTION
Rem      Removes the database components of the Oracle Multimedia 
Rem      PL/SQL Web Toolkit Demo
Rem
Rem    NOTES
Rem      You must be connected as SYS or SYSTEM before running this script
Rem      A logfile is created in remove.log
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rabbott     06/05/09 - XbranchMerge rabbott_update_photoalbum_xmlindex
Rem                           from st_ordim_11.2.0.1
Rem    rabbott     06/05/09 - remove XMLIndexes
Rem    rabbott     05/13/09 - enquote schema
Rem    rabbott     04/03/07 - Oracle interMedia name change to Oracle
Rem                           Multimedia
Rem    rabbott     04/02/07 - remove ctxxpath index(deprecated)
Rem    rabbott     03/16/05 - rabbott_update_plsql_photoalbum
Rem    rabbott     01/27/05 - Created
Rem

spool remove.log

--Remove the Photo Album demo
accept demouser char format a30 prompt "Enter schema to remove Photo Album: "

-- exit if we can't alter the current schema
WHENEVER SQLERROR EXIT;
ALTER SESSION SET CURRENT_SCHEMA="&demouser";

-- set back to continue
WHENEVER SQLERROR CONTINUE;

-- drop the text index
drop index pa_ctx_idx;

-- drop the CTX preference
DECLARE
  pa_schema VARCHAR2(30);
  ctxpref   VARCHAR2(64);
BEGIN
  pa_schema := sys.dbms_assert.enquote_name('&demouser');
  ctxpref := pa_schema || '.PA_CTXIDX';
  ctx_ddl.drop_preference( ctxpref );
END;
/

-- drop the XMLIndex
drop index pa_iptc_idx;
drop index pa_exif_idx;
drop index pa_xmp_idx;

-- drop application objects
drop package photo_album;
drop sequence photos_sequence;
drop table photos purge;
drop table photos_upload purge;

-- revoke the privs
REVOKE EXECUTE ON ctx_ddl FROM "&demouser";

spool off
exit;
